/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.TriangleOscillator;
import com.jsyn.unitgen.UnitOscillator;
import java.awt.BorderLayout;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JLabel;

public class ShowWaves
extends JApplet {
    private Synthesizer synth;
    private UnitOscillator lfo;
    private Add adder;
    private ArrayList<UnitOscillator> oscillators = new ArrayList();
    private LineOut lineOut;
    private AudioScope scope;

    public static void main(String[] args) {
        ShowWaves applet = new ShowWaves();
        JAppletFrame frame = new JAppletFrame("ShowWaves", applet);
        frame.setSize(640, 300);
        frame.setVisible(true);
        frame.test();
    }

    private void setupGUI() {
        this.setLayout(new BorderLayout());
        this.add("North", new JLabel("ShowWaves in an AudioScope Mod001"));
        this.scope = new AudioScope(this.synth);
        for (UnitOscillator osc : this.oscillators) {
            this.scope.addProbe(osc.output);
        }
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.start();
        this.scope.getView().setControlsVisible(true);
        this.add("Center", this.scope.getView());
        this.validate();
    }

    @Override
    public void start() {
        this.synth = JSyn.createSynthesizer();
        this.lfo = new SineOscillator();
        this.synth.add(this.lfo);
        this.adder = new Add();
        this.synth.add(this.adder);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.lfo.frequency.set(0.1);
        this.lfo.amplitude.set(200.0);
        this.adder.inputB.set(400.0);
        this.lfo.output.connect(this.adder.inputA);
        this.oscillators.add(new SawtoothOscillatorBL());
        this.oscillators.add(new SineOscillator());
        this.oscillators.add(new TriangleOscillator());
        for (UnitOscillator osc : this.oscillators) {
            this.synth.add(osc);
            this.adder.output.connect(osc.frequency);
            osc.output.connect(0, this.lineOut.input, 0);
            osc.amplitude.set(0.2);
        }
        this.synth.start();
        this.lineOut.start();
        this.setupGUI();
        this.lineOut.start();
    }

    @Override
    public void stop() {
        this.scope.stop();
        this.synth.stop();
    }
}

