/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.scope.swing;

import com.jsyn.scope.AudioScopeProbe;
import com.jsyn.scope.swing.AudioScopeProbeView;
import com.jsyn.swing.RotaryTextController;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeProbePanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScopeProbePanel.class);
    private static final long serialVersionUID = 4511589171299298548L;
    private AudioScopeProbeView audioScopeProbeView;
    private AudioScopeProbe audioScopeProbe;
    private RotaryTextController verticalScaleKnob;
    private JCheckBox autoBox;
    private JToggleButton.ToggleButtonModel autoScaleModel;

    public ScopeProbePanel(AudioScopeProbeView probeView) {
        this.audioScopeProbeView = probeView;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 3));
        JPanel colorPanel = new JPanel();
        colorPanel.setMinimumSize(new Dimension(40, 40));
        this.audioScopeProbe = probeView.getModel();
        colorPanel.setBackground(this.audioScopeProbe.getColor());
        this.add((Component)colorPanel, "North");
        this.verticalScaleKnob = new RotaryTextController(this.audioScopeProbeView.getWaveTraceView().getVerticalRangeModel(), 5);
        this.add((Component)this.verticalScaleKnob, "Center");
        this.verticalScaleKnob.setTitle("YScale");
        this.autoBox = new JCheckBox("Auto");
        this.autoScaleModel = this.audioScopeProbeView.getWaveTraceView().getAutoButtonModel();
        this.autoScaleModel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JToggleButton.ToggleButtonModel model = (JToggleButton.ToggleButtonModel)e.getSource();
                boolean enabled = !model.isSelected();
                LOGGER.debug("Knob enabled = " + enabled);
                ScopeProbePanel.this.verticalScaleKnob.setEnabled(!model.isSelected());
            }
        });
        this.autoBox.setModel(this.autoScaleModel);
        this.add((Component)this.autoBox, "South");
        this.verticalScaleKnob.setEnabled(!this.autoScaleModel.isSelected());
        this.setMinimumSize(new Dimension(80, 100));
        this.setPreferredSize(new Dimension(80, 150));
        this.setMaximumSize(new Dimension(120, 200));
    }
}

