/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.swing;

import com.jsyn.swing.DoubleBoundedRangeModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExponentialRangeModel
extends DoubleBoundedRangeModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExponentialRangeModel.class);
    private static final long serialVersionUID = -142785624892302160L;
    double a = 1.0;
    double b = -1.0;
    double span = 1.0;
    double root = 10.0;

    public ExponentialRangeModel(String name, int resolution, double dmin, double dmax, double dval) {
        this(name, resolution, dmin, dmax, dval, 1.0);
    }

    ExponentialRangeModel(String name, int resolution, double dmin, double dmax, double dval, double span) {
        super(name, resolution, dmin, dmax, dval);
        this.setRoot(10.0);
        this.setSpan(span);
        this.setDoubleValue(dval);
    }

    private void updateCoefficients() {
        this.a = (this.getDoubleMaximum() - this.getDoubleMinimum()) / (Math.pow(this.root, this.span) - 1.0);
        this.b = this.getDoubleMinimum() - this.a;
    }

    private void setRoot(double w) {
        this.root = w;
        this.updateCoefficients();
    }

    public double getRoot() {
        return this.root;
    }

    public void setSpan(double c) {
        this.span = c;
        this.updateCoefficients();
    }

    public double getSpan() {
        return this.span;
    }

    @Override
    public double sliderToDouble(int sliderValue) {
        this.updateCoefficients();
        double x = (double)sliderValue / (double)this.getMaximum();
        return this.a * Math.pow(this.root, this.span * x) + this.b;
    }

    @Override
    public int doubleToSlider(double dval) {
        this.updateCoefficients();
        double z = (dval - this.b) / this.a;
        double x = Math.log(z) / (this.span * Math.log(this.root));
        return (int)Math.round(x * (double)this.getMaximum());
    }

    public void test(int sliderValue) {
        double dval = this.sliderToDouble(sliderValue);
        int ival = this.doubleToSlider(dval);
        LOGGER.debug(String.valueOf(sliderValue) + " => " + dval + " => " + ival);
    }
}

