/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;
import com.jsyn.util.AutoCorrelator;
import com.jsyn.util.SignalCorrelator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PitchDetector
extends UnitGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PitchDetector.class);
    public UnitInputPort input;
    public UnitOutputPort period;
    public UnitOutputPort confidence;
    public UnitOutputPort frequency;
    public UnitOutputPort updated;
    protected SignalCorrelator signalCorrelator;
    private double lastFrequency = 440.0;
    private double lastPeriod = 44100.0 / this.lastFrequency;
    private double lastConfidence = 0.0;
    private static final int LOWEST_FREQUENCY = 40;
    private static final int HIGHEST_RATE = 48000;
    private static final int CYCLES_NEEDED = 2;

    public PitchDetector() {
        this.input = new UnitInputPort("Input");
        this.addPort(this.input);
        this.period = new UnitOutputPort("Period");
        this.addPort(this.period);
        this.confidence = new UnitOutputPort("Confidence");
        this.addPort(this.confidence);
        this.frequency = new UnitOutputPort("Frequency");
        this.addPort(this.frequency);
        this.updated = new UnitOutputPort("Updated");
        this.addPort(this.updated);
        this.signalCorrelator = this.createSignalCorrelator();
    }

    public SignalCorrelator createSignalCorrelator() {
        int framesNeeded = 2400;
        return new AutoCorrelator(framesNeeded);
    }

    @Override
    public void generate(int start, int limit) {
        double[] inputs = this.input.getValues();
        double[] periods = this.period.getValues();
        double[] confidences = this.confidence.getValues();
        double[] frequencies = this.frequency.getValues();
        double[] updateds = this.updated.getValues();
        int i = start;
        while (i < limit) {
            double current = inputs[i];
            if (this.signalCorrelator.addSample(current)) {
                this.lastPeriod = this.signalCorrelator.getPeriod();
                if (this.lastPeriod < 0.1) {
                    LOGGER.debug("ILLEGAL PERIOD");
                }
                double currentFrequency = (double)this.getFrameRate() / (this.lastPeriod + 0.0);
                double confidence = this.signalCorrelator.getConfidence();
                if (confidence > 0.1) {
                    double coefficient = confidence * 0.2;
                    this.lastFrequency = this.lastFrequency * (1.0 - coefficient) + currentFrequency * coefficient;
                }
                this.lastConfidence = confidence;
                updateds[i] = 1.0;
            } else {
                updateds[i] = 0.0;
            }
            periods[i] = this.lastPeriod;
            confidences[i] = this.lastConfidence;
            frequencies[i] = this.lastFrequency;
            ++i;
        }
    }

    public float[] getDiffs() {
        return this.signalCorrelator.getDiffs();
    }
}

