/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.unitgen.UnitOscillator;

public class PulseOscillator
extends UnitOscillator {
    public UnitInputPort width = new UnitInputPort("Width");

    public PulseOscillator() {
        this.addPort(this.width);
    }

    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] widths = this.width.getValues();
        double[] outputs = this.output.getValues();
        double currentPhase = this.phase.getValue();
        int i = start;
        while (i < limit) {
            double phaseIncrement = this.convertFrequencyToPhaseIncrement(frequencies[i]);
            currentPhase = this.incrementWrapPhase(currentPhase, phaseIncrement);
            double ampl = amplitudes[i];
            outputs[i] = currentPhase < widths[i] ? -ampl : ampl;
            ++i;
        }
        this.phase.setValue(currentPhase);
    }
}

