/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumericOutput {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumericOutput.class);

    static char digitToChar(int digit) {
        if (digit > 9) {
            return (char)(65 + digit - 10);
        }
        return (char)(48 + digit);
    }

    public static String integerToString(int n, int width, boolean leadingZeros) {
        return NumericOutput.integerToString(n, width, leadingZeros, 10);
    }

    public static String integerToString(int n, int width) {
        return NumericOutput.integerToString(n, width, false, 10);
    }

    /*
     * Unable to fully structure code
     */
    public static String integerToString(int n, int width, boolean leadingZeros, int radix) {
        block10: {
            if (width > 32) {
                width = 32;
            }
            buf = new StringBuffer();
            ln = n;
            ifNeg = false;
            if (radix != 10) {
                ln &= 0xFFFFFFFFL;
            } else if (ln < 0L) {
                ifNeg = true;
                ln = -ln;
            }
            if (ln != 0L) ** GOTO lbl20
            buf.append('0');
            break block10;
lbl-1000:
            // 1 sources

            {
                rem = (int)(ln % (long)radix);
                buf.append(NumericOutput.digitToChar(rem));
                ln /= (long)radix;
lbl20:
                // 2 sources

                ** while (ln > 0L)
            }
        }
        if (leadingZeros) {
            pl = width;
            if (ifNeg) {
                --pl;
            }
            i = buf.length();
            while (i < pl) {
                buf.append('0');
                ++i;
            }
        }
        if (ifNeg) {
            buf.append('-');
        }
        i = buf.length();
        while (i < width) {
            buf.append(' ');
            ++i;
        }
        buf.reverse();
        return buf.toString();
    }

    public static String doubleToString(double value, int width, int places) {
        return NumericOutput.doubleToString(value, width, places, false);
    }

    public static String doubleToString(double value, int width, int places, boolean leadingZeros) {
        if (width > 32) {
            width = 32;
        }
        if (places > 16) {
            places = 16;
        }
        boolean ifNeg = false;
        if (value < 0.0) {
            ifNeg = true;
            value = -value;
        }
        int ival = (int)Math.floor(value += 0.5 * Math.pow(10.0, 0 - places));
        int fval = (int)((value - Math.floor(value)) * Math.pow(10.0, places));
        String result = "";
        result = String.valueOf(result) + NumericOutput.integerToString(ival, 0, false, 10);
        result = String.valueOf(result) + ".";
        result = String.valueOf(result) + NumericOutput.integerToString(fval, places, true, 10);
        if (leadingZeros) {
            int zw = width;
            if (ifNeg) {
                --zw;
            }
            while (result.length() < zw) {
                result = "0" + result;
            }
            if (ifNeg) {
                result = "-" + result;
            }
        } else {
            if (ifNeg) {
                result = "-" + result;
            }
            while (result.length() < width) {
                result = " " + result;
            }
        }
        return result;
    }

    static void testInteger(int n) {
        LOGGER.debug("Test " + n + ", 0x" + Integer.toHexString(n) + ", %" + Integer.toBinaryString(n));
        LOGGER.debug("  +,8,t,10 = " + NumericOutput.integerToString(n, 8, true, 10));
        LOGGER.debug("  +,8,f,10 = " + NumericOutput.integerToString(n, 8, false, 10));
        LOGGER.debug("  -,8,t,10 = " + NumericOutput.integerToString(-n, 8, true, 10));
        LOGGER.debug("  -,8,f,10 = " + NumericOutput.integerToString(-n, 8, false, 10));
        LOGGER.debug("  +,8,t,16 = " + NumericOutput.integerToString(n, 8, true, 16));
        LOGGER.debug("  +,8,f,16 = " + NumericOutput.integerToString(n, 8, false, 16));
        LOGGER.debug("  -,8,t,16 = " + NumericOutput.integerToString(-n, 8, true, 16));
        LOGGER.debug("  -,8,f,16 = " + NumericOutput.integerToString(-n, 8, false, 16));
        LOGGER.debug("  +,8,t, 2 = " + NumericOutput.integerToString(n, 8, true, 2));
        LOGGER.debug("  +,8,f, 2 = " + NumericOutput.integerToString(n, 8, false, 2));
    }

    static void testDouble(double value) {
        LOGGER.debug("Test " + value);
        LOGGER.debug("  +,5,1 = " + NumericOutput.doubleToString(value, 5, 1));
        LOGGER.debug("  -,5,1 = " + NumericOutput.doubleToString(-value, 5, 1));
        LOGGER.debug("  +,14,3 = " + NumericOutput.doubleToString(value, 14, 3));
        LOGGER.debug("  -,14,3 = " + NumericOutput.doubleToString(-value, 14, 3));
        LOGGER.debug("  +,6,2,true = " + NumericOutput.doubleToString(value, 6, 2, true));
        LOGGER.debug("  -,6,2,true = " + NumericOutput.doubleToString(-value, 6, 2, true));
    }

    public static void main(String[] argv) {
        LOGGER.debug("Test NumericOutput");
        NumericOutput.testInteger(0);
        NumericOutput.testInteger(1);
        NumericOutput.testInteger(16);
        NumericOutput.testInteger(23456);
        NumericOutput.testInteger(144470);
        NumericOutput.testInteger(563900);
        NumericOutput.testDouble(0.0);
        NumericOutput.testDouble(0.0678);
        NumericOutput.testDouble(0.1234567);
        NumericOutput.testDouble(1.234567);
        NumericOutput.testDouble(12.34567);
        NumericOutput.testDouble(123.4567);
        NumericOutput.testDouble(1234.5678);
    }
}

