/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util.soundfile;

import com.jsyn.data.FloatSample;
import com.jsyn.data.SampleMarker;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.soundfile.AudioFileParser;
import com.jsyn.util.soundfile.IFFParser;
import java.io.EOFException;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIFFFileParser
extends AudioFileParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(AIFFFileParser.class);
    private static final String SUPPORTED_FORMATS = "Only 16 and 24 bit PCM or 32-bit float AIF files supported.";
    static final int AIFF_ID = 1095321158;
    static final int AIFC_ID = 1095321155;
    static final int COMM_ID = 1129270605;
    static final int SSND_ID = 1397968452;
    static final int MARK_ID = 1296126539;
    static final int INST_ID = 1229869908;
    static final int NONE_ID = 1313820229;
    static final int FL32_ID = 1179398962;
    static final int FL32_ID_LC = 1718367026;
    int sustainBeginID = -1;
    int sustainEndID = -1;
    int releaseBeginID = -1;
    int releaseEndID = -1;
    boolean typeFloat = false;

    @Override
    FloatSample finish() throws IOException {
        this.setLoops();
        if (this.byteData == null) {
            throw new IOException("No data found in audio sample.");
        }
        float[] floatData = new float[this.numFrames * this.samplesPerFrame];
        if (this.bitsPerSample == 16) {
            SampleLoader.decodeBigI16ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
        } else if (this.bitsPerSample == 24) {
            SampleLoader.decodeBigI24ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
        } else if (this.bitsPerSample == 32) {
            if (this.typeFloat) {
                SampleLoader.decodeBigF32ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
            } else {
                SampleLoader.decodeBigI32ToF32(this.byteData, 0, this.byteData.length, floatData, 0);
            }
        } else {
            throw new IOException("Only 16 and 24 bit PCM or 32-bit float AIF files supported. size = " + this.bitsPerSample);
        }
        return this.makeSample(floatData);
    }

    double read80BitFloat() throws IOException {
        byte[] bytes = new byte[10];
        this.parser.read(bytes);
        int exp = (bytes[0] & 0x3F) << 8 | bytes[1] & 0xFF;
        int mant = (bytes[2] & 0xFF) << 16 | (bytes[3] & 0xFF) << 8 | bytes[4] & 0xFF;
        return (double)mant / (double)(1 << 22 - exp);
    }

    void parseCOMMChunk(IFFParser parser, int ckSize) throws IOException {
        this.samplesPerFrame = parser.readShortBig();
        this.numFrames = parser.readIntBig();
        this.bitsPerSample = parser.readShortBig();
        this.frameRate = this.read80BitFloat();
        if (ckSize > 18) {
            int format = parser.readIntBig();
            if (format == 1179398962 || format == 1718367026) {
                this.typeFloat = true;
            } else if (format == 1313820229) {
                this.typeFloat = false;
            } else {
                throw new IOException("Only 16 and 24 bit PCM or 32-bit float AIF files supported. format " + IFFParser.IDToString(format));
            }
        }
        this.bytesPerSample = (this.bitsPerSample + 7) / 8;
        this.bytesPerFrame = this.bytesPerSample * this.samplesPerFrame;
    }

    void parseINSTChunk(IFFParser parser, int ckSize) throws IOException {
        byte baseNote = parser.readByte();
        byte detune = parser.readByte();
        this.originalPitch = (double)baseNote + 0.01 * (double)detune;
        byte lowNote = parser.readByte();
        byte highNote = parser.readByte();
        parser.skip(2L);
        short gain = parser.readShortBig();
        short playMode = parser.readShortBig();
        this.sustainBeginID = parser.readShortBig();
        this.sustainEndID = parser.readShortBig();
        playMode = parser.readShortBig();
        this.releaseBeginID = parser.readShortBig();
        this.releaseEndID = parser.readShortBig();
    }

    private void setLoops() {
        SampleMarker cuePoint = (SampleMarker)this.cueMap.get(this.sustainBeginID);
        if (cuePoint != null) {
            this.sustainBegin = cuePoint.position;
        }
        if ((cuePoint = (SampleMarker)this.cueMap.get(this.sustainEndID)) != null) {
            this.sustainEnd = cuePoint.position;
        }
    }

    void parseSSNDChunk(IFFParser parser, int ckSize) throws IOException {
        long numRead;
        int offset = parser.readIntBig();
        parser.readIntBig();
        parser.skip(offset);
        this.dataPosition = parser.getOffset();
        int numBytes = ckSize - 8 - offset;
        if (this.ifLoadData) {
            this.byteData = new byte[numBytes];
            numRead = parser.read(this.byteData);
        } else {
            numRead = parser.skip(numBytes);
        }
        if (numRead != (long)numBytes) {
            throw new EOFException("AIFF data chunk too short!");
        }
    }

    void parseMARKChunk(IFFParser parser, int ckSize) throws IOException {
        long startOffset = parser.getOffset();
        int numCuePoints = parser.readShortBig();
        int i = 0;
        while (i < numCuePoints) {
            long numInMark = parser.getOffset() - startOffset;
            if (numInMark >= (long)ckSize) {
                LOGGER.debug("Reached end of MARK chunk with bogus numCuePoints = " + numCuePoints);
                break;
            }
            short uniqueID = parser.readShortBig();
            int position = parser.readIntBig();
            int len = parser.read();
            String markerName = this.parseString(parser, len);
            if ((len & 1) == 0) {
                parser.skip(1L);
            }
            SampleMarker cuePoint = this.findOrCreateCuePoint(uniqueID);
            cuePoint.position = position;
            cuePoint.name = markerName;
            if (IFFParser.debug) {
                LOGGER.debug("AIFF Marker at " + position + ", " + markerName);
            }
            ++i;
        }
    }

    @Override
    public void handleForm(IFFParser parser, int ckID, int ckSize, int type) throws IOException {
        if (ckID == 1179603533 && type != 1095321158 && type != 1095321155) {
            throw new IOException("Bad AIFF form type = " + IFFParser.IDToString(type));
        }
    }

    @Override
    public void handleChunk(IFFParser parser, int ckID, int ckSize) throws IOException {
        switch (ckID) {
            case 1129270605: {
                this.parseCOMMChunk(parser, ckSize);
                break;
            }
            case 1397968452: {
                this.parseSSNDChunk(parser, ckSize);
                break;
            }
            case 1296126539: {
                this.parseMARKChunk(parser, ckSize);
                break;
            }
            case 1229869908: {
                this.parseINSTChunk(parser, ckSize);
                break;
            }
        }
    }
}

