/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.math;

import com.softsynth.math.ChebyshevPolynomial;
import com.softsynth.math.Polynomial;

public class PolynomialTableData {
    double[] data;
    Polynomial polynomial;

    public PolynomialTableData(Polynomial polynomial, int numFrames) {
        this.data = new double[numFrames];
        this.polynomial = polynomial;
        this.buildData();
    }

    public double[] getData() {
        return this.data;
    }

    void buildData() {
        double xInterval = 2.0 / (double)(this.data.length - 1);
        int i = 0;
        while (i < this.data.length) {
            double x = (double)i * xInterval - 1.0;
            this.data[i] = this.polynomial.evaluate(x);
            ++i;
        }
    }

    public static void main(String[] args) {
        PolynomialTableData chebData = new PolynomialTableData(ChebyshevPolynomial.T(2), 8);
    }
}

