/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model;

import com.syntona.model.SyntonaCommand;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.core.PatchModule;
import com.syntona.plugin.Jack;
import com.syntona.plugin.SyntonaModule;

public class ConnectJacksCommand
implements SyntonaCommand {
    int sourceModuleId;
    String sourceJackName;
    int destinationModuleId;
    String destinationJackName;
    private PatchModule mPatchModule;
    private String sourceModuleName;
    private String destinationModuleName;

    public ConnectJacksCommand(int sourceModuleId, String sourceJackName, int destinationModuleId, String destinationJackName) {
        this.sourceModuleId = sourceModuleId;
        this.sourceJackName = sourceJackName;
        this.destinationModuleId = destinationModuleId;
        this.destinationJackName = destinationJackName;
    }

    @Override
    public void execute() {
        SyntonaEngine syntonaEngine = SyntonaEngine.getInstance();
        SyntonaModule sourceModule = syntonaEngine.getModuleById(this.sourceModuleId);
        Jack sourceJack = sourceModule.getJackByName(this.sourceJackName);
        if (sourceJack == null) {
            System.err.println("Jack " + this.sourceJackName + " not found.");
        } else {
            SyntonaModule destinationModule = syntonaEngine.getModuleById(this.destinationModuleId);
            Jack destinationJack = destinationModule.getJackByName(this.destinationJackName);
            if (destinationJack == null) {
                System.err.println("Jack " + this.destinationJackName + " not found.");
            } else {
                sourceJack.connect(destinationJack);
                this.sourceModuleName = sourceModule.getName();
                this.destinationModuleName = destinationModule.getName();
                this.mPatchModule = sourceModule.getParent();
                SyntonaEngine.getInstance().pushUndoCommand(this);
            }
        }
    }

    @Override
    public void undo() {
        SyntonaModule sourceModule = this.mPatchModule.findModuleByName(this.sourceModuleName);
        if (sourceModule == null) {
            System.err.println("Module " + this.sourceModuleName + " not found.");
            return;
        }
        Jack sourceJack = sourceModule.getJackByName(this.sourceJackName);
        if (sourceJack == null) {
            System.err.println("Jack " + this.sourceJackName + " not found.");
            return;
        }
        SyntonaModule destinationModule = this.mPatchModule.findModuleByName(this.destinationModuleName);
        if (destinationModule == null) {
            System.err.println("Module " + this.destinationModuleName + " not found.");
            return;
        }
        Jack destinationJack = destinationModule.getJackByName(this.destinationJackName);
        if (destinationJack == null) {
            System.err.println("Jack " + this.destinationJackName + " not found.");
            return;
        }
        sourceJack.disconnect(destinationJack);
        sourceModule.getParent().firePatchChanged();
    }

    public String toString() {
        return "connect " + this.sourceJackName + " to " + this.destinationJackName;
    }
}

