/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.ports.UnitOutputPort;
import com.softsynth.util.IndentingWriter;
import com.syntona.model.SyntonaExporter;
import com.syntona.model.core.PatchModule;
import com.syntona.model.jsyn.InputAudioJack;
import com.syntona.model.jsyn.OutputAudioJack;
import com.syntona.model.jsyn.UnitPortModule;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.SyntonaModule;

public class AudioOutputJackModule
extends UnitPortModule {
    private final OutputAudioJack[] outputs;
    private final InputAudioJack[] inputs;
    private final int mNumParts;

    public AudioOutputJackModule(int numParts) {
        super(numParts);
        this.mNumParts = numParts;
        this.inputs = new InputAudioJack[numParts];
        this.outputs = new OutputAudioJack[numParts];
        int i = 0;
        while (i < numParts) {
            String jackName = "input";
            if (numParts > 1) {
                jackName = String.valueOf(jackName) + i;
            }
            this.inputs[i] = new InputAudioJack(this, jackName, this.tiePoint.input, i);
            this.inputs[i].setHelp("send to parent");
            ++i;
        }
    }

    public AudioOutputJackModule() {
        this(1);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        int i = 0;
        while (i < this.mNumParts) {
            String jackName = name;
            if (this.mNumParts > 1) {
                jackName = String.valueOf(jackName) + i;
            }
            if (this.outputs[i] != null) {
                this.outputs[i].setName(jackName);
                this.outputs[i].setDefaultText(name);
            }
            ++i;
        }
    }

    @Override
    public void removedFromPatch() {
        int i = 0;
        while (i < this.mNumParts) {
            this.getParent().removeJack(this.outputs[i]);
            ++i;
        }
        super.removedFromPatch();
    }

    @Override
    public void addedToPatch(PatchModule parent) {
        super.addedToPatch(parent);
        int i = 0;
        while (i < this.mNumParts) {
            String jackName = this.getName();
            if (this.mNumParts > 1) {
                jackName = String.valueOf(jackName) + i;
            }
            this.outputs[i] = new OutputAudioJack((SyntonaModule)parent, jackName, "output from patch");
            this.outputs[i].setSynthPort(this.tiePoint.output);
            this.outputs[i].setPartIndex(i);
            ++i;
        }
    }

    @Override
    public void kick() {
        int i = 0;
        while (i < this.mNumParts) {
            PatchMessage msg = this.inputs[i].getLastMessage();
            this.outputs[i].passMessage(msg);
            ++i;
        }
    }

    private String getExportedPortName() {
        return super.getName();
    }

    @Override
    public boolean validateExport() {
        boolean ok = super.validateExport();
        if (!SyntonaExporter.validateExportedName(this.getExportedPortName())) {
            ok = false;
        }
        return ok;
    }

    @Override
    public void exportJavaSource(SyntonaExporter exporter, int phase) {
        super.exportJavaSource(exporter, phase);
        IndentingWriter writer = exporter.getWriter();
        switch (phase) {
            case 0: {
                exporter.addClass(UnitOutputPort.class);
                break;
            }
            case 2: {
                writer.println("public UnitOutputPort " + this.getExportedPortName() + ";");
                break;
            }
            case 4: {
                writer.println("addPort(" + this.getExportedPortName() + " = " + this.getExportedObjectName() + ".output, \"" + this.getExportedPortName() + "\");");
            }
        }
    }
}

