/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.util.TransportListener;
import com.jsyn.util.TransportModel;
import com.jsyn.util.WaveRecorder;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.model.jsyn.JSynMixer;
import com.syntona.model.jsyn.VolumeMeter;
import com.syntona.plugin.TimeLabel;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class JSynToolBar
extends JToolBar
implements TransportListener {
    private JButton startButton;
    private JButton stopButton;
    private TimeLabel positionLabel;
    private int frameRate;
    private JComboBox maxMinutesBox;
    private WaveRecorder recorder;
    protected double maxRecordingTime;
    private Timer timer;

    public JSynToolBar(final JSynMixer mixer) {
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        layout.setHgap(4);
        this.frameRate = JSynBundle.getSynthesizer().getFrameRate();
        this.add(new JLabel("JSyn:"));
        this.startButton = new JButton("Capture...");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    JSynToolBar.this.recorder = mixer.openCapture();
                    if (JSynToolBar.this.recorder != null) {
                        JSynToolBar.this.recorder.addTransportListener(JSynToolBar.this);
                        JSynToolBar.this.recorder.setMaxRecordingTime(JSynToolBar.this.maxRecordingTime);
                        mixer.startCapture();
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    mixer.stopCapture();
                    mixer.closeCapture();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.stopButton.setEnabled(false);
        this.add(this.stopButton);
        this.positionLabel = new TimeLabel();
        this.add(this.positionLabel);
        String NO_LIMIT = "--";
        String[] maxNames = new String[]{"1", "2", "3", "5", "10", "20", "60", "--"};
        this.maxMinutesBox = new JComboBox<String>(maxNames);
        this.maxMinutesBox.setSelectedIndex(4);
        this.maxMinutesBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int maxMinutes = 0;
                String s = (String)JSynToolBar.this.maxMinutesBox.getSelectedItem();
                if (!"--".equals(s)) {
                    maxMinutes = Integer.parseInt(s);
                }
                JSynToolBar.this.maxRecordingTime = (double)maxMinutes * 60.0;
                WaveRecorder waveRecorder = JSynToolBar.this.recorder;
                if (waveRecorder != null) {
                    waveRecorder.setMaxRecordingTime(JSynToolBar.this.maxRecordingTime);
                }
            }
        });
        this.add(new JLabel("Max:"));
        this.add(this.maxMinutesBox);
        this.maxMinutesBox.setSelectedIndex(2);
        this.add(new JLabel("minutes"));
        final VolumeMeter vuMeter = new VolumeMeter(0, 2);
        vuMeter.setPreferredSize(new Dimension(80, 15));
        this.add(vuMeter);
        this.timer = new Timer(33, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                double volume0 = mixer.getMasterVolume(0);
                double volume1 = mixer.getMasterVolume(1);
                vuMeter.volumeChanged(volume0, volume1);
            }
        });
        this.timer.start();
        this.validate();
    }

    @Override
    public void positionChanged(TransportModel transportModel, final long position) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSynToolBar.this.positionLabel.setTime((double)position / (double)JSynToolBar.this.frameRate);
            }
        });
    }

    @Override
    public void stateChanged(TransportModel transportModel, final int state) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean running = state == 2;
                JSynToolBar.this.startButton.setEnabled(!running);
                JSynToolBar.this.stopButton.setEnabled(running);
                if (!running) {
                    JSynToolBar.this.recorder = null;
                }
            }
        });
    }
}

