/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.ModuleInfo;
import com.syntona.plugin.ModulePresenter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JToolBar;

public abstract class Bundle {
    HashMap<String, ModuleInfo> moduleMap;
    protected Vector<ModuleInfo> infos = new Vector();

    public Bundle() {
        this.addClasses();
        this.makeModuleMap();
    }

    public abstract void addClasses();

    public abstract String getName();

    public void addModuleInfo(ModuleInfo info) {
        this.infos.add(info);
        info.setBundle(this);
    }

    public ModuleInfo addModule(String type, Class<?> moduleClass) {
        return this.addModule(null, type, moduleClass, type);
    }

    public ModuleInfo addModule(String group, String type, Class<?> moduleClass) {
        return this.addModule(group, type, moduleClass, type);
    }

    public ModuleInfo addModule(String group, String type, Class<?> moduleClass, String legalName) {
        return this.addModule(group, type, moduleClass, null, legalName);
    }

    public ModuleInfo addModule(String group, String type, Class<?> moduleClass, Class<?> viewClass) {
        return this.addModule(group, type, moduleClass, viewClass, type);
    }

    public ModuleInfo addModule(String group, String type, Class<?> moduleClass, Class<?> viewClass, String legalName) {
        ModuleInfo info = new ModuleInfo(group, type, moduleClass, viewClass, legalName);
        this.addModuleInfo(info);
        return info;
    }

    protected void makeModuleMap() {
        this.moduleMap = new HashMap();
        Iterator<ModuleInfo> infoIterator = this.getModuleInfos();
        while (infoIterator.hasNext()) {
            ModuleInfo moduleInfo = infoIterator.next();
            this.moduleMap.put(moduleInfo.getType(), moduleInfo);
        }
    }

    public ModulePresenter createModule(String type, PatchModulePresenter parentPresenter) {
        ModulePresenter presenter = null;
        ModuleInfo moduleInfo = this.moduleMap.get(type);
        if (moduleInfo == null) {
            throw new IllegalArgumentException("Module type \"" + type + "\" not recognized.");
        }
        try {
            presenter = moduleInfo.makeModulePresenter();
            String uniqueName = moduleInfo.getLegalName();
            if (parentPresenter != null) {
                uniqueName = parentPresenter.makeNameUnique(uniqueName);
            }
            presenter.getModule().setName(uniqueName);
            presenter.getModule().setBundle(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return presenter;
    }

    public Iterator<ModuleInfo> getModuleInfos() {
        return this.infos.iterator();
    }

    public void start() {
    }

    public void stop() {
    }

    public JToolBar getToolbar() {
        return null;
    }
}

