/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.jsyn.util.NumericOutput;
import com.syntona.gui.patch.InputDoubleJackEditor;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.plugin.DoubleRangeModel;
import com.syntona.plugin.EngineController;
import com.syntona.plugin.InputJack;
import com.syntona.plugin.Jack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputJack;
import com.syntona.plugin.PatchMessage;
import com.syntona.plugin.PatchMessageDouble;
import com.syntona.plugin.SyntonaModule;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Element;

public class InputDoubleJack
extends InputJack {
    private static final double DEFAULT_MIN = 0.0;
    private static final double DEFAULT_MAX = 100.0;
    private DoubleRangeModel mDoubleModel;
    private boolean mCopyConnectionEnabled = true;
    private ChangeListener mPreviousKickListener;

    public InputDoubleJack(SyntonaModule module, String name) {
        this(module, name, false);
    }

    public InputDoubleJack(SyntonaModule module, String name, boolean exponential) {
        this(module, name, new DoubleRangeModel(0.0, 0.0, 100.0, exponential));
    }

    public InputDoubleJack(SyntonaModule module, String name, DoubleRangeModel model) {
        super(module, name, "");
        this.mDoubleModel = model;
    }

    @Override
    public void loadContents(Element jackElement) {
        this.setMin(XMLDOMLoader.parseDoubleAttribute(jackElement, "min"));
        this.setMax(XMLDOMLoader.parseDoubleAttribute(jackElement, "max"));
        this.setValue(XMLDOMLoader.parseDoubleAttribute(jackElement, "value"));
    }

    @Override
    public void save(SyntonaSaver saver) {
        saver.beginElement("jack");
        this.saveAttributes(saver);
        saver.endElement();
    }

    public void saveAttributes(SyntonaSaver saver) {
        saver.addAttribute("name", this.name);
        saver.addAttribute("min", "" + this.getMin());
        saver.addAttribute("max", "" + this.getMax());
        saver.addAttribute("value", "" + this.getValue());
    }

    @Override
    public void passMessage(PatchMessage msg) {
        if (msg instanceof PatchMessageDouble) {
            double v = ((PatchMessageDouble)msg).getValue();
            this.setValue(v);
        }
        super.passMessage(msg);
    }

    @Override
    public boolean willAccept(Jack other) {
        if (other instanceof OutputJack) {
            OutputJack otherOutputJack = (OutputJack)other;
            return super.willAccept(other) && !this.detectRecursion(otherOutputJack);
        }
        return false;
    }

    public void addChangeListener(ChangeListener listener) {
        this.mDoubleModel.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.mDoubleModel.addChangeListener(listener);
    }

    public double getValue() {
        return this.mDoubleModel.getValue();
    }

    public void setValue(double d) {
        this.mDoubleModel.setValue(d);
    }

    public void clipAndSetValue(double d) {
        if (d < this.getMin()) {
            d = this.getMin();
        } else if (d > this.getMax()) {
            d = this.getMax();
        }
        this.mDoubleModel.setValue(d);
    }

    public double getMin() {
        return this.mDoubleModel.getMinimum();
    }

    public void setMin(double min) {
        this.mDoubleModel.setMinimum(min);
    }

    public double getMax() {
        return this.mDoubleModel.getMaximum();
    }

    public void setMax(double max) {
        this.mDoubleModel.setMaximum(max);
    }

    public BoundedRangeModel getBoundedRangeModel() {
        return this.mDoubleModel.getBoundedRangeModel();
    }

    public DoubleRangeModel getDoubleRangeModel() {
        return this.mDoubleModel;
    }

    @Override
    public String getValueText() {
        return NumericOutput.doubleToString(this.getValue(), 1, 4);
    }

    @Override
    public JackEditor getEditor(ModulePresenter modulePresenter) {
        return new InputDoubleJackEditor(this, modulePresenter);
    }

    public void setCopyConnectionEnabled(boolean b) {
        this.mCopyConnectionEnabled = b;
    }

    public boolean isCopyConnectionEnabled() {
        return this.mCopyConnectionEnabled;
    }

    public void setKickableIfOtherNotConnected(final InputJack other) {
        this.setKickable(false);
        final EngineController engine = this.getModule().getEngine();
        BoundedRangeModel rangeModel = this.getBoundedRangeModel();
        if (this.mPreviousKickListener != null) {
            rangeModel.removeChangeListener(this.mPreviousKickListener);
        }
        ChangeListener kickListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (other.getConnectedCount() == 0) {
                    engine.sendKickModule(InputDoubleJack.this.getModule());
                }
            }
        };
        rangeModel.addChangeListener(kickListener);
        this.mPreviousKickListener = kickListener;
    }
}

