/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.plugin;

import com.syntona.gui.patch.ModuleEditor;
import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PatchFrame;
import com.syntona.model.SyntonaEngine;
import com.syntona.model.SyntonaLoader;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.XMLDOMLoader;
import com.syntona.model.core.PatchModulePresenter;
import com.syntona.plugin.Jack;
import com.syntona.plugin.Loadable;
import com.syntona.plugin.ModuleInfo;
import com.syntona.plugin.Saveable;
import com.syntona.plugin.SyntonaModule;
import com.syntona.tools.FileTools;
import java.awt.Component;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ModulePresenter
implements Saveable,
Loadable {
    private static final String TAG_EDITOR = "editor";
    private SyntonaModule module;
    private ModuleView view;
    private PatchModulePresenter parent;
    private File file;
    private ModuleEditor moduleEditor;
    private ModuleInfo mInfo;
    protected Rectangle mEditorBounds;

    public ModulePresenter() {
    }

    public ModulePresenter(SyntonaModule module) {
        this.module = module;
    }

    public void setType(String type) {
        this.module.setType(type);
    }

    public SyntonaModule getModule() {
        return this.module;
    }

    public void setModule(SyntonaModule module) {
        this.module = module;
    }

    public ModuleView getView() {
        return this.view;
    }

    public void setView(ModuleView view) {
        if (view.getPresenter() == null) {
            view.setPresenter(this);
        }
        this.view = view;
    }

    public ModuleInfo getInfo() {
        return this.mInfo;
    }

    public void setInfo(ModuleInfo info) {
        this.mInfo = info;
    }

    public void delete() {
        this.hideMainEditor();
        if (this.parent != null) {
            this.getModule().disconnectAllJacks();
            this.getModule().removedFromPatch();
            this.parent.remove(this);
        }
    }

    public PatchFrame getParentPatchFrame() {
        if (this.parent == null) {
            return null;
        }
        return this.parent.getPatchFrame();
    }

    public void addedToPatch(PatchModulePresenter parent) {
        this.parent = parent;
        this.getModule().addedToPatch(parent.getPatchModule());
    }

    public ModuleEditor createModuleEditor() {
        return new ModuleEditor(this.view);
    }

    public Component showJackEditor() {
        if (this.moduleEditor == null || !this.moduleEditor.isVisible()) {
            this.moduleEditor = this.createModuleEditor();
            if (this.mEditorBounds != null) {
                this.moduleEditor.setBounds(this.mEditorBounds);
            }
            this.moduleEditor.show();
        }
        return this.moduleEditor.getComponent();
    }

    public void hideMainEditor() {
        if (this.moduleEditor != null) {
            this.moduleEditor.setVisible(false);
        }
    }

    public Component showMainEditor() {
        return this.showJackEditor();
    }

    @Override
    public void save(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        Rectangle editorBounds;
        saver.beginElement("module");
        this.module.saveAttributes(saver);
        if (this.view != null) {
            this.view.save(saver, topLevel);
        }
        if ((editorBounds = this.getEditorBounds()) != null) {
            saver.beginElement(TAG_EDITOR);
            saver.saveBounds(editorBounds);
            saver.endElement();
        }
        this.saveContents(saver, topLevel);
        this.module.saveJacks(saver);
        saver.endElement();
    }

    public void load(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        Rectangle editorBounds;
        this.getView().setSelected(loader.isAutoSelectEnabled());
        this.getView().load(loader, moduleElement);
        Element editorElement = XMLDOMLoader.getChildByTagName(moduleElement, TAG_EDITOR);
        if (editorElement != null && (editorBounds = loader.loadBounds(editorElement)) != null) {
            this.setEditorBounds(editorBounds);
        }
        int savedX = loader.getOffsetX();
        int savedY = loader.getOffsetY();
        loader.setOffsetX(0);
        loader.setOffsetY(0);
        this.loadContents(loader, moduleElement);
        loader.setOffsetX(savedX);
        loader.setOffsetY(savedY);
    }

    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        this.module.saveContents(saver, topLevel);
    }

    public void loadJacks(Element moduleElement) {
        List<Element> nl = XMLDOMLoader.getChildrenByTagName(moduleElement, "jack");
        if (nl != null) {
            int i = 0;
            while (i < nl.size()) {
                Element jackElement = nl.get(i);
                String jackName = jackElement.getAttribute("name");
                Jack jack = this.getModule().getJackByName(jackName);
                if (jack != null) {
                    jack.loadContents(jackElement);
                } else {
                    System.err.println("Could not find jack " + jackName);
                }
                ++i;
            }
        }
    }

    public void onLoad() {
        this.module.onLoad();
    }

    public void loadContents(SyntonaLoader loader, Element moduleElement) throws ParserConfigurationException, SAXException, IOException {
        this.module.loadContents(loader, moduleElement);
        this.loadJacks(moduleElement);
    }

    public void markDirty() {
        if (this.parent != null) {
            this.parent.markDirty();
        }
    }

    public void markClean() {
    }

    public PatchModulePresenter getParent() {
        return this.parent;
    }

    public void setParent(PatchModulePresenter parent) {
        this.parent = parent;
    }

    public boolean saveIfDirty() throws ParserConfigurationException {
        return false;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean checkFileRecursion(File saveFile, int level) {
        return level > 0 && saveFile.equals(this.file);
    }

    public void reset() {
        this.getModule().reset();
    }

    public boolean isResettable() {
        return this.getModule().isResettable();
    }

    public int getWidthToSave() {
        return this.getView().getWidth();
    }

    public int getHeightToSave() {
        return this.getView().getHeight();
    }

    public Rectangle getEditorBounds() {
        if (this.moduleEditor == null) {
            return this.mEditorBounds;
        }
        return this.moduleEditor.getBounds();
    }

    public void setEditorBounds(Rectangle editorBounds) {
        this.mEditorBounds = editorBounds;
        if (this.moduleEditor != null) {
            this.moduleEditor.setBounds(editorBounds);
        }
    }

    public PatchFrame getPatchFrame() {
        return this.getParentPatchFrame();
    }

    public int askUserYesNoCancel(String message, String title) {
        int result;
        if (this.getPatchFrame() != null) {
            this.getPatchFrame().moveToFront();
            result = JOptionPane.showInternalConfirmDialog(this.getPatchFrame(), message, title, 1, 2);
        } else {
            result = JOptionPane.showConfirmDialog(null, message, title, 1, 2);
        }
        return result;
    }

    protected File findFileToLoad(String fileName, File referenceFile, String title, String suffix) {
        String message;
        int result;
        File fileToLoad = FileTools.resolveRelativePath(referenceFile, fileName = FileTools.convertFileSeparatorsToHost(fileName));
        if (fileToLoad == null && (result = this.askUserYesNoCancel(message = "Do you want to find the missing file: " + fileName, title)) == 0) {
            File missingFile = new File(fileName);
            File existingParent = FileTools.findExistingParent(fileName);
            if (existingParent == null) {
                existingParent = referenceFile.getParentFile();
            }
            File lookHere = new File(existingParent, missingFile.getName());
            fileToLoad = SyntonaEngine.getInstance().getGUIService().askOpenFile(lookHere, suffix);
            if (fileToLoad != null) {
                this.markDirty();
            }
        }
        return fileToLoad;
    }
}

