/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.devices.jportaudio;

import com.jsyn.devices.AudioDeviceInputStream;
import com.jsyn.devices.AudioDeviceManager;
import com.jsyn.devices.AudioDeviceOutputStream;
import com.portaudio.BlockingStream;
import com.portaudio.DeviceInfo;
import com.portaudio.HostApiInfo;
import com.portaudio.PortAudio;
import com.portaudio.StreamParameters;

public class JPortAudioDevice
implements AudioDeviceManager {
    private double suggestedOutputLatency = 0.03;
    private double suggestedInputLatency = 0.05;
    private static final int FRAMES_PER_BUFFER = 128;

    public JPortAudioDevice() {
        PortAudio.initialize();
    }

    @Override
    public int getDeviceCount() {
        return PortAudio.getDeviceCount();
    }

    @Override
    public String getDeviceName(int deviceID) {
        DeviceInfo deviceInfo = PortAudio.getDeviceInfo(deviceID);
        HostApiInfo hostInfo = PortAudio.getHostApiInfo(deviceInfo.hostApi);
        return String.valueOf(deviceInfo.name) + " - " + hostInfo.name;
    }

    @Override
    public int getDefaultInputDeviceID() {
        return PortAudio.getDefaultInputDevice();
    }

    @Override
    public int getDefaultOutputDeviceID() {
        return PortAudio.getDefaultOutputDevice();
    }

    @Override
    public int getMaxInputChannels(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).maxInputChannels;
    }

    @Override
    public int getMaxOutputChannels(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).maxOutputChannels;
    }

    @Override
    public double getDefaultLowInputLatency(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).defaultLowInputLatency;
    }

    @Override
    public double getDefaultHighInputLatency(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultInputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).defaultHighInputLatency;
    }

    @Override
    public double getDefaultLowOutputLatency(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).defaultLowOutputLatency;
    }

    @Override
    public double getDefaultHighOutputLatency(int deviceID) {
        if (deviceID < 0) {
            deviceID = PortAudio.getDefaultOutputDevice();
        }
        return PortAudio.getDeviceInfo((int)deviceID).defaultHighOutputLatency;
    }

    @Override
    public int setSuggestedOutputLatency(double latency) {
        this.suggestedOutputLatency = latency;
        return 0;
    }

    @Override
    public int setSuggestedInputLatency(double latency) {
        this.suggestedInputLatency = latency;
        return 0;
    }

    @Override
    public AudioDeviceOutputStream createOutputStream(int deviceID, int frameRate, int samplesPerFrame) {
        return new JPAOutputStream(deviceID, frameRate, samplesPerFrame);
    }

    @Override
    public AudioDeviceInputStream createInputStream(int deviceID, int frameRate, int samplesPerFrame) {
        return new JPAInputStream(deviceID, frameRate, samplesPerFrame);
    }

    @Override
    public String getName() {
        return "JPortAudio";
    }

    private class JPAInputStream
    extends JPAStream
    implements AudioDeviceInputStream {
        private JPAInputStream(int deviceID, int frameRate, int samplesPerFrame) {
            this.samplesPerFrame = samplesPerFrame;
            StreamParameters streamParameters = new StreamParameters();
            streamParameters.channelCount = samplesPerFrame;
            if (deviceID < 0) {
                deviceID = PortAudio.getDefaultInputDevice();
            }
            streamParameters.device = deviceID;
            streamParameters.suggestedLatency = JPortAudioDevice.this.suggestedInputLatency;
            int flags = 0;
            this.blockingStream = PortAudio.openStream(streamParameters, null, frameRate, 128, flags);
        }

        @Override
        public double read() {
            double[] buffer = new double[1];
            this.read(buffer, 0, 1);
            return buffer[0];
        }

        @Override
        public int read(double[] buffer) {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        public int read(double[] buffer, int start, int count) {
            if (this.floatBuffer == null || this.floatBuffer.length < count) {
                this.floatBuffer = new float[count];
            }
            this.blockingStream.read(this.floatBuffer, count / this.samplesPerFrame);
            int i = 0;
            while (i < count) {
                buffer[i + start] = this.floatBuffer[i];
                ++i;
            }
            return count;
        }

        @Override
        public double getLatency() {
            return this.blockingStream.getInfo().inputLatency;
        }

        @Override
        public int available() {
            return this.blockingStream.getReadAvailable() * this.samplesPerFrame;
        }
    }

    private class JPAOutputStream
    extends JPAStream
    implements AudioDeviceOutputStream {
        private JPAOutputStream(int deviceID, int frameRate, int samplesPerFrame) {
            this.samplesPerFrame = samplesPerFrame;
            StreamParameters streamParameters = new StreamParameters();
            streamParameters.channelCount = samplesPerFrame;
            if (deviceID < 0) {
                deviceID = PortAudio.getDefaultOutputDevice();
            }
            streamParameters.device = deviceID;
            streamParameters.suggestedLatency = JPortAudioDevice.this.suggestedOutputLatency;
            int flags = 0;
            this.blockingStream = PortAudio.openStream(null, streamParameters, frameRate, 128, flags);
        }

        @Override
        public void write(double value) {
            double[] buffer = new double[]{value};
            this.write(buffer, 0, 1);
        }

        @Override
        public void write(double[] buffer) {
            this.write(buffer, 0, buffer.length);
        }

        @Override
        public void write(double[] buffer, int start, int count) {
            if (this.floatBuffer == null || this.floatBuffer.length < count) {
                this.floatBuffer = new float[count];
            }
            int i = 0;
            while (i < count) {
                this.floatBuffer[i] = (float)buffer[i + start];
                ++i;
            }
            this.blockingStream.write(this.floatBuffer, count / this.samplesPerFrame);
        }

        @Override
        public double getLatency() {
            return this.blockingStream.getInfo().outputLatency;
        }
    }

    private static class JPAStream {
        BlockingStream blockingStream;
        float[] floatBuffer = null;
        int samplesPerFrame;

        private JPAStream() {
        }

        public void close() {
            this.blockingStream.close();
        }

        public void start() {
            this.blockingStream.start();
        }

        public void stop() {
            this.blockingStream.stop();
        }
    }
}

