/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.instruments.WaveShapingVoice;
import com.jsyn.scope.AudioScope;
import com.jsyn.swing.JAppletFrame;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.UnitVoice;
import com.jsyn.util.PseudoRandom;
import com.jsyn.util.VoiceAllocator;
import com.softsynth.math.AudioMath;
import com.softsynth.shared.time.TimeStamp;
import java.awt.BorderLayout;
import javax.swing.JApplet;

public class ChebyshevSong
extends JApplet
implements Runnable {
    private Synthesizer synth;
    private Add mixer;
    private LineOut lineOut;
    private AudioScope scope;
    private volatile boolean go = false;
    private PseudoRandom pseudo = new PseudoRandom();
    private static final int MAX_VOICES = 8;
    private static final int MAX_NOTES = 5;
    private VoiceAllocator allocator;
    private static final int[] scale;

    static {
        int[] nArray = new int[5];
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 7;
        nArray[4] = 9;
        scale = nArray;
    }

    public static void main(String[] args) {
        ChebyshevSong applet = new ChebyshevSong();
        JAppletFrame frame = new JAppletFrame("ChebyshevSong", applet);
        frame.setSize(640, 300);
        frame.setVisible(true);
        frame.test();
    }

    @Override
    public void start() {
        this.setLayout(new BorderLayout());
        this.synth = JSyn.createSynthesizer();
        this.mixer = new Add();
        this.synth.add(this.mixer);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.mixer.output.connect(0, this.lineOut.input, 0);
        this.mixer.output.connect(0, this.lineOut.input, 1);
        UnitVoice[] voices = new WaveShapingVoice[8];
        int i = 0;
        while (i < 8) {
            WaveShapingVoice voice = new WaveShapingVoice();
            this.synth.add(voice);
            voice.usePreset(0);
            voice.getOutput().connect(this.mixer.inputA);
            voices[i] = voice;
            ++i;
        }
        this.allocator = new VoiceAllocator(voices);
        this.synth.start();
        this.lineOut.start();
        this.scope = new AudioScope(this.synth);
        this.scope.addProbe(this.mixer.output);
        this.scope.setTriggerMode(AudioScope.TriggerMode.NORMAL);
        this.scope.getView().setControlsVisible(false);
        this.add("Center", this.scope.getView());
        this.scope.start();
        this.getParent().validate();
        this.getToolkit().sync();
        Thread thread = new Thread(this);
        this.go = true;
        thread.start();
    }

    @Override
    public void stop() {
        this.go = false;
        this.removeAll();
        this.synth.stop();
    }

    double indexToFrequency(int index) {
        int octave = index / scale.length;
        int temp = index % scale.length;
        int pitch = scale[temp] + 12 * octave;
        return AudioMath.pitchToFrequency(pitch + 16);
    }

    private void noteOff(double time, int noteNumber) {
        this.allocator.noteOff(noteNumber, new TimeStamp(time));
    }

    private void noteOn(double time, int noteNumber) {
        double frequency = this.indexToFrequency(noteNumber);
        double amplitude = 0.1;
        TimeStamp timeStamp = new TimeStamp(time);
        this.allocator.noteOn(noteNumber, frequency, amplitude, timeStamp);
        this.allocator.setPort(noteNumber, "Range", 0.7, this.synth.createTimeStamp());
    }

    @Override
    public void run() {
        int savedSeed = (int)System.currentTimeMillis();
        double duration = 0.2;
        double advanceTime = 0.5;
        double nextTime = this.synth.getCurrentTime() + advanceTime;
        double onTime = duration / 2.0;
        int beatIndex = 0;
        try {
            do {
                if ((beatIndex & 7) == 0) {
                    if (Math.random() < 0.5) {
                        this.pseudo.setSeed(savedSeed);
                    } else if (Math.random() < 0.5) {
                        savedSeed = this.pseudo.getSeed();
                    }
                }
                int numNotes = this.pseudo.choose(5);
                int i = 0;
                while (i < numNotes) {
                    int noteNumber = this.pseudo.choose(30);
                    this.noteOn(nextTime, noteNumber);
                    this.noteOff(nextTime + onTime, noteNumber);
                    ++i;
                }
                ++beatIndex;
                this.synth.sleepUntil((nextTime += duration) - advanceTime);
            } while (this.go);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

