/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.Spectrum;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.PassThrough;
import com.jsyn.unitgen.SawtoothOscillatorBL;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.SpectralFilter;
import com.jsyn.unitgen.SpectralProcessor;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.WhiteNoise;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class HearSpectralFilter {
    private Synthesizer synth;
    private PassThrough center;
    private UnitOscillator osc;
    private UnitOscillator lfo;
    private PassThrough mixer;
    private SpectralFilter filter;
    private LineOut lineOut;
    private WaveRecorder recorder;
    private static final boolean useRecorder = true;
    private static final boolean useProcessor = true;
    private static final int NUM_FFTS = 4;
    private static final int SIZE_LOG_2 = 10;
    private static final int SIZE = 1024;
    private SpectralProcessor[] processors;
    private WhiteNoise noise;
    private static int SAMPLE_RATE = 44100;

    private void test() throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(true);
        File waveFile = new File("temp_recording.wav");
        this.recorder = new WaveRecorder(this.synth, waveFile);
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        this.processors = new SpectralProcessor[4];
        int i = 0;
        while (i < 4) {
            this.processors[i] = new CustomSpectralProcessor();
            ++i;
        }
        this.center = new PassThrough();
        this.synth.add(this.center);
        this.lfo = new SineOscillator();
        this.synth.add(this.lfo);
        this.noise = new WhiteNoise();
        this.synth.add(this.noise);
        this.mixer = new PassThrough();
        this.synth.add(this.mixer);
        this.osc = new SawtoothOscillatorBL();
        this.synth.add(this.osc);
        this.filter = new SpectralFilter(4, 10);
        this.synth.add(this.filter);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.center.output.connect(this.osc.frequency);
        this.lfo.output.connect(this.osc.frequency);
        this.osc.output.connect(this.mixer.input);
        this.noise.output.connect(this.mixer.input);
        this.mixer.output.connect(this.filter.input);
        i = 0;
        while (i < 4) {
            this.filter.getSpectralOutput(i).connect(this.processors[i].input);
            this.processors[i].output.connect(this.filter.getSpectralInput(i));
            ++i;
        }
        this.mixer.output.connect(0, this.lineOut.input, 0);
        this.filter.output.connect(0, this.lineOut.input, 1);
        this.center.input.set(600.0);
        this.lfo.frequency.set(0.2);
        this.lfo.amplitude.set(400.0);
        this.osc.amplitude.set(0.2);
        this.noise.amplitude.set(0.2);
        this.synth.start(SAMPLE_RATE);
        this.mixer.output.connect(0, this.recorder.getInput(), 0);
        this.filter.output.connect(0, this.recorder.getInput(), 1);
        this.recorder.start();
        this.lineOut.start();
        System.out.println("You should now be hearing a noise+sawtooth on the left channel,");
        System.out.println("and the FFT->IFFT processed signal on the right channel.");
        try {
            double time = this.synth.getCurrentTime();
            this.synth.sleepUntil(time + 10.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.close();
        }
        System.out.println("Stop playing. -------------------");
        this.synth.stop();
    }

    public static void main(String[] args) {
        try {
            new HearSpectralFilter().test();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class CustomSpectralProcessor
    extends SpectralProcessor {
        public CustomSpectralProcessor() {
            super(1024);
        }

        @Override
        public void processSpectrum(Spectrum inputSpectrum, Spectrum outputSpectrum) {
            this.lowPassFilter(inputSpectrum, outputSpectrum, 1500.0);
        }

        public void lowPassFilter(Spectrum inputSpectrum, Spectrum outputSpectrum, double frequency) {
            inputSpectrum.copyTo(outputSpectrum);
            double[] outReal = outputSpectrum.getReal();
            double[] outImag = outputSpectrum.getImaginary();
            int size = outReal.length;
            int cutoff = (int)(frequency * (double)size / (double)SAMPLE_RATE);
            int nyquist = size / 2;
            int i = cutoff;
            while (i < nyquist) {
                outReal[size - i] = 0.0;
                outReal[i] = 0.0;
                outImag[size - i] = 0.0;
                outImag[i] = 0.0;
                ++i;
            }
        }

        public void pitchUpOctave(Spectrum inputSpectrum, Spectrum outputSpectrum) {
            outputSpectrum.clear();
            double[] inReal = inputSpectrum.getReal();
            double[] inImag = inputSpectrum.getImaginary();
            double[] outReal = outputSpectrum.getReal();
            double[] outImag = outputSpectrum.getImaginary();
            int size = inReal.length;
            int nyquist = size / 2;
            int i = nyquist - 2;
            while (i > 1) {
                int h = i / 2;
                outReal[i] = inReal[h];
                outImag[i] = inImag[h];
                outReal[size - i] = inReal[size - h];
                outImag[size - i] = inImag[size - h];
                --i;
            }
        }
    }
}

