/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.data.SegmentedEnvelope;
import com.jsyn.unitgen.ExponentialRamp;
import com.jsyn.unitgen.LatchZeroCrossing;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.VariableRateDataReader;
import com.jsyn.unitgen.VariableRateMonoReader;
import com.jsyn.util.WaveRecorder;
import java.io.File;
import java.io.IOException;

public class NotesToTone {
    private static final double SONG_AMPLITUDE = 0.7;
    private static final double INTRO_DURATION = 2.0;
    private static final double OUTRO_DURATION = 2.0;
    private static final double RAMP_DURATION = 20.0;
    private static final double LOW_FREQUENCY = 1.0;
    private static final double HIGH_FREQUENCY = 800.0;
    private static final boolean useRecorder = true;
    private WaveRecorder recorder;
    private Synthesizer synth;
    private ExponentialRamp envSweeper;
    private ExponentialRamp oscSweeper;
    private VariableRateDataReader envelopePlayer;
    private UnitOscillator osc;
    private LatchZeroCrossing latch;
    private LineOut lineOut;
    private SegmentedEnvelope envelope;

    private void play() throws IOException {
        this.synth = JSyn.createSynthesizer();
        this.synth.setRealTime(true);
        File waveFile = new File("notes_to_tone.wav");
        this.recorder = new WaveRecorder(this.synth, waveFile, 1);
        System.out.println("Writing to WAV file " + waveFile.getAbsolutePath());
        this.createUnits();
        this.connectUnits();
        this.setupEnvelope();
        this.osc.amplitude.set(0.7);
        this.envSweeper.current.set(1.0);
        this.envSweeper.input.set(1.0);
        this.envSweeper.time.set(20.0);
        this.oscSweeper.current.set(800.0);
        this.oscSweeper.input.set(800.0);
        this.oscSweeper.time.set(20.0);
        this.synth.start();
        if (this.recorder != null) {
            this.recorder.start();
        }
        this.lineOut.start();
        double timeNow = this.synth.getCurrentTime();
        double songDuration = 24.0;
        this.envSweeper.input.set(800.0, timeNow + 2.0);
        this.oscSweeper.input.set(1.0, timeNow + 2.0);
        this.latch.gate.set(0.0, timeNow + songDuration);
        try {
            this.synth.sleepUntil(timeNow + songDuration + 2.0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.recorder != null) {
            this.recorder.stop();
            this.recorder.close();
        }
        this.synth.stop();
    }

    private void createUnits() {
        this.osc = new SineOscillator();
        this.synth.add(this.osc);
        this.envSweeper = new ExponentialRamp();
        this.synth.add(this.envSweeper);
        this.oscSweeper = new ExponentialRamp();
        this.synth.add(this.oscSweeper);
        this.latch = new LatchZeroCrossing();
        this.synth.add(this.latch);
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.envelopePlayer = new VariableRateMonoReader();
        this.synth.add(this.envelopePlayer);
    }

    private void connectUnits() {
        this.oscSweeper.output.connect(this.osc.frequency);
        this.osc.output.connect(this.latch.input);
        this.latch.output.connect(this.envelopePlayer.amplitude);
        this.envSweeper.output.connect(this.envelopePlayer.rate);
        this.envelopePlayer.output.connect(0, this.lineOut.input, 0);
        if (this.recorder != null) {
            this.envelopePlayer.output.connect(0, this.recorder.getInput(), 0);
        }
    }

    private void setupEnvelope() {
        double[] pairs = new double[20];
        int i = 0;
        pairs[i++] = 0.15;
        pairs[i++] = 0.0;
        pairs[i++] = 0.05;
        pairs[i++] = 1.0;
        pairs[i++] = 0.1;
        pairs[i++] = 0.6;
        pairs[i++] = 0.1;
        pairs[i++] = 0.6;
        pairs[i++] = 0.1;
        pairs[i++] = 0.0;
        int halfLength = i;
        while (i < pairs.length) {
            pairs[i] = pairs[i - halfLength];
            pairs[++i] = pairs[i - halfLength] * -1.0;
            ++i;
        }
        this.envelope = new SegmentedEnvelope(pairs);
        this.envelopePlayer.dataQueue.queueLoop(this.envelope, 0, this.envelope.getNumFrames());
    }

    public static void main(String[] args) {
        try {
            new NotesToTone().play();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

