/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.examples;

import com.jsyn.JSyn;
import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.Add;
import com.jsyn.unitgen.AsymptoticRamp;
import com.jsyn.unitgen.Circuit;
import com.jsyn.unitgen.LineOut;
import com.jsyn.unitgen.Pan;
import com.jsyn.unitgen.SawtoothOscillatorDPW;
import com.jsyn.unitgen.SineOscillator;
import com.jsyn.unitgen.UnitOscillator;
import com.jsyn.unitgen.UnitSource;

public class SwarmOfOscillators {
    private Synthesizer synth;
    Follower[] followers;
    SineOscillator lfo;
    LineOut lineOut;
    private Add tiePoint;
    private static final int NUM_FOLLOWERS = 30;

    private void test() {
        this.synth = JSyn.createSynthesizer();
        this.lineOut = new LineOut();
        this.synth.add(this.lineOut);
        this.tiePoint = new Add();
        this.synth.add(this.tiePoint);
        this.lfo = new SineOscillator();
        this.synth.add(this.lfo);
        this.lfo.amplitude.set(40.0);
        this.lfo.frequency.set(2.3);
        this.followers = new Follower[30];
        int i = 0;
        while (i < this.followers.length) {
            Follower follower = new Follower();
            this.synth.add(follower);
            follower.getOutput().connect(0, this.lineOut.input, 0);
            follower.getOutput().connect(1, this.lineOut.input, 1);
            this.followers[i] = follower;
            ++i;
        }
        this.synth.start();
        this.lineOut.start();
        double timeNow = this.synth.getCurrentTime();
        double duration = 0.9;
        double time = timeNow + duration;
        double freq = 400.0;
        this.tiePoint.inputA.set(freq, time);
        try {
            int i2 = 0;
            while (i2 < 20) {
                freq = 200.0 + Math.random() * 500.0;
                this.tiePoint.inputA.set(freq, time += duration);
                this.synth.sleepUntil(time - 0.2);
                ++i2;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.format("CPU usage = %4.2f%c\n", this.synth.getUsage() * 100.0, Character.valueOf('%'));
        this.synth.stop();
    }

    public static void main(String[] args) {
        new SwarmOfOscillators().test();
    }

    class Follower
    extends Circuit
    implements UnitSource {
        UnitOscillator osc = new SawtoothOscillatorDPW();
        AsymptoticRamp lag;
        Pan panner;

        Follower() {
            this.add(this.osc);
            this.osc.amplitude.set(0.03);
            this.lag = new AsymptoticRamp();
            this.add(this.lag);
            double hlife = 0.01 + Math.random() * 0.9;
            this.lag.halfLife.set(hlife);
            this.panner = new Pan();
            this.add(this.panner);
            this.panner.pan.set(Math.random() * 2.0 - 1.0);
            ((SwarmOfOscillators)SwarmOfOscillators.this).tiePoint.output.connect(this.lag.input);
            SwarmOfOscillators.this.lfo.output.connect(this.lag.input);
            this.lag.output.connect(this.osc.frequency);
            this.osc.output.connect(this.panner.input);
        }

        @Override
        public UnitOutputPort getOutput() {
            return this.panner.output;
        }
    }
}

