/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.unitgen;

import com.jsyn.ports.UnitInputPort;
import com.jsyn.ports.UnitOutputPort;
import com.jsyn.unitgen.UnitGenerator;

public class ParabolicEnvelope
extends UnitGenerator {
    public UnitInputPort frequency;
    public UnitInputPort triggerInput = new UnitInputPort("Input");
    public UnitInputPort amplitude;
    public UnitOutputPort triggerOutput;
    public UnitOutputPort triggerPass;
    public UnitOutputPort output;
    private double slope;
    private double curve;
    private double level;
    private boolean running;

    public ParabolicEnvelope() {
        this.addPort(this.triggerInput);
        this.frequency = new UnitInputPort("Frequency", 440.0);
        this.addPort(this.frequency);
        this.amplitude = new UnitInputPort("Amplitude", 1.0);
        this.addPort(this.amplitude);
        this.output = new UnitOutputPort("Output");
        this.addPort(this.output);
        this.triggerOutput = new UnitOutputPort("TriggerOutput");
        this.addPort(this.triggerOutput);
        this.triggerPass = new UnitOutputPort("TriggerPass");
        this.addPort(this.triggerPass);
    }

    @Override
    public void generate(int start, int limit) {
        double[] frequencies = this.frequency.getValues();
        double[] amplitudes = this.amplitude.getValues();
        double[] triggerInputs = this.triggerInput.getValues();
        double[] outputs = this.output.getValues();
        double[] triggerPasses = this.triggerPass.getValues();
        double[] triggerOutputs = this.triggerOutput.getValues();
        int i = start;
        while (i < limit) {
            if (!this.running) {
                if (triggerInputs[i] > 0.0) {
                    double freq = frequencies[i] * this.synthesisEngine.getInverseNyquist();
                    freq = freq > 1.0 ? 1.0 : (freq < -1.0 ? -1.0 : freq);
                    double ampl = amplitudes[i];
                    double freq2 = freq * freq;
                    this.slope = 4.0 * ampl * (freq - freq2);
                    this.curve = -8.0 * ampl * freq2;
                    this.level = 0.0;
                    triggerOutputs[i] = 1.0;
                    this.running = true;
                } else {
                    triggerOutputs[i] = 0.0;
                }
                triggerPasses[i] = 0.0;
            } else {
                this.level += this.slope;
                this.slope += this.curve;
                if (this.level <= 0.0) {
                    this.level = 0.0;
                    this.running = false;
                }
                triggerOutputs[i] = 0.0;
                triggerPasses[i] = triggerInputs[i];
            }
            outputs[i] = this.level;
            ++i;
        }
    }
}

