/*
 * Decompiled with CFR 0.152.
 */
package com.jsyn.util;

import com.jsyn.Synthesizer;
import com.jsyn.ports.UnitInputPort;
import com.jsyn.util.AudioStreamReader;
import com.jsyn.util.StreamingThread;
import com.jsyn.util.TransportListener;
import com.jsyn.util.TransportModel;
import com.jsyn.util.WaveFileWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class WaveRecorder {
    private AudioStreamReader reader;
    private WaveFileWriter writer;
    private StreamingThread thread;
    private Synthesizer synth;
    private TransportModel transportModel = new TransportModel();
    private double maxRecordingTime;

    public WaveRecorder(Synthesizer synth, File outputFile) throws FileNotFoundException {
        this(synth, outputFile, 2, 16);
    }

    public WaveRecorder(Synthesizer synth, File outputFile, int samplesPerFrame) throws FileNotFoundException {
        this(synth, outputFile, samplesPerFrame, 16);
    }

    public WaveRecorder(Synthesizer synth, File outputFile, int samplesPerFrame, int bitsPerSample) throws FileNotFoundException {
        this.synth = synth;
        this.reader = new AudioStreamReader(synth, samplesPerFrame);
        this.writer = new WaveFileWriter(outputFile);
        this.writer.setFrameRate(synth.getFrameRate());
        this.writer.setSamplesPerFrame(samplesPerFrame);
        this.writer.setBitsPerSample(bitsPerSample);
    }

    public UnitInputPort getInput() {
        return this.reader.getInput();
    }

    public void start() {
        this.stop();
        this.thread = new StreamingThread(this.reader, this.writer);
        this.thread.setTransportModel(this.transportModel);
        this.thread.setSamplesPerFrame(this.writer.getSamplesPerFrame());
        this.updateMaxRecordingTime();
        this.thread.start();
    }

    public void stop() {
        if (this.thread != null) {
            this.reader.close();
            this.thread.requestStop();
            try {
                this.thread.join(500L);
            }
            catch (InterruptedException ignored) {
                System.out.println("join() " + ignored);
            }
            this.thread = null;
        }
    }

    public void close() throws IOException {
        this.stop();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.reader != null) {
            this.reader.close();
            int i = 0;
            while (i < this.reader.getInput().getNumParts()) {
                this.reader.getInput().disconnectAll(i);
                ++i;
            }
            this.reader = null;
        }
    }

    public void addTransportListener(TransportListener listener) {
        this.transportModel.addTransportListener(listener);
    }

    public void removeTransportListener(TransportListener listener) {
        this.transportModel.removeTransportListener(listener);
    }

    public void setMaxRecordingTime(double maxRecordingTime) {
        this.maxRecordingTime = maxRecordingTime;
        this.updateMaxRecordingTime();
    }

    private void updateMaxRecordingTime() {
        StreamingThread streamingThread = this.thread;
        if (streamingThread != null) {
            long maxFrames = (long)(this.maxRecordingTime * (double)this.synth.getFrameRate());
            streamingThread.setMaxFrames(maxFrames);
        }
    }
}

