/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.Score;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreInstrument;
import com.softsynth.score.ScoreParser;

public class ScorePlayer {
    private double advance = 0.0;
    private double chaseUntil = 0.0;
    private double stopAfter = 0.0;
    private ScoreClock clock;

    public ScorePlayer(ScoreClock clock) {
        this.clock = clock;
    }

    public double playScoreText(String text, ScoreInstrument instrument, double time) throws InterruptedException {
        ScoreParser parser = new ScoreParser();
        Score score = parser.parse(text);
        System.out.println("Score = " + score);
        return this.play(score, time);
    }

    public void waitUntil(double time) throws InterruptedException {
        if (this.stopAfter > this.chaseUntil && time > this.stopAfter) {
            throw new InterruptedException("Stopping because at end of score section.");
        }
        this.clock.sleepUntilScoreTime(time - this.getAdvance());
    }

    public double getAdvance() {
        return this.advance;
    }

    public void setAdvance(double advance) {
        this.advance = advance;
    }

    public double getChaseUntil() {
        return this.chaseUntil;
    }

    public void setChaseUntil(double chaseUntil) {
        this.chaseUntil = chaseUntil;
    }

    public double getStopAfter() {
        return this.stopAfter;
    }

    public void setStopAfter(double stopAfter) {
        this.stopAfter = stopAfter;
    }

    public double play(ScoreElement scoreElement, double time) throws InterruptedException {
        ScoreElementPlayer elementPlayer = scoreElement.start(null, time);
        double nextTime = time;
        while (!elementPlayer.isDone()) {
            this.waitUntil(nextTime);
            nextTime = elementPlayer.advance(nextTime);
        }
        return nextTime;
    }
}

