/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.score;

import com.softsynth.score.Column;
import com.softsynth.score.PrintingScoreInstrument;
import com.softsynth.score.Score;
import com.softsynth.score.ScoreClock;
import com.softsynth.score.ScoreElement;
import com.softsynth.score.ScoreElementPlayer;
import com.softsynth.score.ScoreNote;
import com.softsynth.score.ScorePlayer;
import com.softsynth.score.ScoreQueue;
import com.softsynth.score.Sequence;
import java.util.List;
import junit.framework.TestCase;

public class TestScore
extends TestCase {
    int numStarted;
    int lastPitch = 40;

    public void checkSequence(double time) throws InterruptedException {
        this.lastPitch = 50;
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        ScorePlayer scorePlayer = new ScorePlayer(new NoWaitClock());
        Score score = new Score();
        score.setInstrument(instrument);
        score.add(new AssertiveScoreNote(1.0, time + 0.0));
        score.add(new AssertiveScoreNote(1.0, time + 1.0));
        score.add(new AssertiveScoreNote(0.5, time + 2.0));
        score.add(new AssertiveScoreNote(1.0, time + 2.5));
        this.numStarted = 0;
        scorePlayer.play(score, time);
        TestScore.assertEquals("all notes started", 4, this.numStarted);
    }

    public void testSequence() throws InterruptedException {
        this.checkSequence(0.0);
        this.checkSequence(3.7);
    }

    public void checkColumn(double time) throws InterruptedException {
        this.lastPitch = 40;
        ScorePlayer scorePlayer = new ScorePlayer(new NoWaitClock());
        Column chord = new Column();
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        chord.setInstrument(instrument);
        chord.add(new AssertiveScoreNote(0.5, time));
        chord.add(new AssertiveScoreNote(1.0, time));
        chord.add(new AssertiveScoreNote(0.7, time));
        this.numStarted = 0;
        scorePlayer.play(chord, time);
        TestScore.assertEquals("all notes started", 3, this.numStarted);
    }

    public void testColumn() throws InterruptedException {
        this.checkColumn(0.0);
        this.checkColumn(0.9);
    }

    public void testColumnInSequence() throws InterruptedException {
        this.lastPitch = 40;
        ScorePlayer scorePlayer = new ScorePlayer(new NoWaitClock());
        Column chord = new Column();
        Sequence sequence = new Sequence();
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        sequence.setInstrument(instrument);
        sequence.add(new AssertiveScoreNote(1.0, 0.0));
        double chordTime = 1.0;
        chord.add(new AssertiveScoreNote(0.4, chordTime));
        chord.add(new AssertiveScoreNote(1.0, chordTime));
        chord.add(new AssertiveScoreNote(0.5, chordTime));
        sequence.add(chord);
        sequence.add(new AssertiveScoreNote(1.0, 2.0));
        this.numStarted = 0;
        scorePlayer.play(sequence, 0.0);
        TestScore.assertEquals("all notes started", 5, this.numStarted);
    }

    public void testParallelSequence() throws InterruptedException {
        this.lastPitch = 40;
        ScorePlayer scorePlayer = new ScorePlayer(new NoWaitClock());
        Sequence sequence = new Sequence();
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        sequence.setInstrument(instrument);
        double time = 0.0;
        sequence.add(new AssertiveScoreNote(1.0, time + 0.0));
        sequence.add(new AssertiveScoreNote(1.0, time + 1.0));
        sequence.add(new AssertiveScoreNote(0.5, time + 2.0));
        sequence.add(new AssertiveScoreNote(1.0, time + 2.5));
        Column chord = new Column();
        chord.add(sequence);
        chord.add(sequence);
        this.numStarted = 0;
        scorePlayer.play(chord, time);
        TestScore.assertEquals("all notes started", 8, this.numStarted);
    }

    public void testQueue() throws InterruptedException {
        this.lastPitch = 40;
        ScorePlayer scorePlayer = new ScorePlayer(new NoWaitClock());
        ScoreQueue scoreQueue = new ScoreQueue();
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        scoreQueue.setInstrument(instrument);
        double time = 0.0;
        scoreQueue.add(new AssertiveScoreNote(1.0, time + 0.0));
        scoreQueue.add(new AssertiveScoreNote(1.0, time + 1.0));
        scoreQueue.add(new AssertiveScoreNote(0.5, time + 2.0));
        scoreQueue.add(new AssertiveScoreNote(1.0, time + 2.5));
        this.numStarted = 0;
        scorePlayer.play(scoreQueue, time);
        TestScore.assertEquals("all notes started", 4, this.numStarted);
    }

    public void testClone() throws CloneNotSupportedException {
        PrintingScoreInstrument instrument = new PrintingScoreInstrument();
        ScoreNote n1 = new ScoreNote(1.5);
        n1.setValue(14.5);
        n1.setInstrument(instrument);
        ScoreNote n2 = (ScoreNote)n1.clone();
        TestScore.assertEquals("cloned duration", (Object)n1.getDuration(), (Object)n2.getDuration());
        TestScore.assertEquals("cloned value", (Object)n1.getValue(), (Object)n2.getValue());
        Sequence seq1 = new Sequence();
        seq1.add(new ScoreNote(0.5));
        n1.setValue(9.3);
        seq1.add(n1);
        Sequence seq2 = (Sequence)seq1.clone();
        int n = seq1.size();
        List<ScoreElement> el1 = seq1.getElements();
        List<ScoreElement> el2 = seq1.getElements();
        int i = 0;
        while (i < n) {
            ScoreElement e2;
            ScoreElement e1 = el1.get(i);
            TestScore.assertTrue("not ==", e1 != (e2 = el2.get(i)));
            TestScore.assertTrue("equals()", e1.equals(e2));
            TestScore.assertEquals("cloned amplitude", (Object)e1.getAmplitude(), (Object)e2.getAmplitude());
            ++i;
        }
    }

    class AssertiveScoreNote
    extends ScoreNote {
        double expectedTime;

        public AssertiveScoreNote(double duration, double expectedTime) {
            super(duration);
            this.setValue(TestScore.this.lastPitch++);
            this.expectedTime = expectedTime;
        }

        public AssertiveScoreNote(double time) {
            this(time, time);
        }

        @Override
        public ScoreElementPlayer start(ScoreElementPlayer parentPlayer, double time) {
            ++TestScore.this.numStarted;
            TestScore.assertEquals(this.expectedTime, time, 0.01);
            return super.start(parentPlayer, time);
        }
    }

    class NoWaitClock
    extends ScoreClock {
        double lastTime;

        NoWaitClock() {
        }

        @Override
        public double getRealTime() {
            return this.lastTime;
        }

        @Override
        public void sleepUntilRealTime(double realTime) throws InterruptedException {
            this.lastTime = realTime;
        }
    }
}

