/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.gui.patch;

import com.syntona.gui.patch.ModuleView;
import com.syntona.gui.patch.PlayOverrideFocusListener;
import com.syntona.plugin.JTextFieldDirty;
import com.syntona.plugin.Jack;
import com.syntona.plugin.JackEditor;
import com.syntona.plugin.SyntonaModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ModuleEditor {
    ModuleView moduleView;
    private JPanel fullPanel;
    private JDialog dialog;
    protected int mComponentX;
    protected int mComponentY;
    private Rectangle mBounds;

    public ModuleEditor(ModuleView moduleView) {
        this.moduleView = moduleView;
        SyntonaModule module = moduleView.getModule();
        this.fullPanel = new JPanel();
        this.fullPanel.setLayout(new BorderLayout());
        this.fullPanel.add(this.createNameEditor(), "North");
        this.fullPanel.add(this.setupJackEditors(moduleView, module.getJacksToEdit()), "Center");
        this.fullPanel.validate();
    }

    public Component setupJackEditors(ModuleView moduleView, Jack[] jacks) {
        JPanel jackPanel = new JPanel();
        jackPanel.setLayout(new GridLayout(0, 1));
        int totalHeight = 0;
        Jack[] jackArray = jacks;
        int n = jacks.length;
        int n2 = 0;
        while (n2 < n) {
            Jack jack = jackArray[n2];
            JackEditor jackEditor = jack.getEditor(moduleView.getPresenter());
            if (jackEditor != null) {
                Component component = jackEditor.getComponent();
                totalHeight += component.getPreferredSize().height;
                jackPanel.add(jackEditor.getComponent());
            }
            ++n2;
        }
        System.out.println("setupJackEditors, totalHeight = " + totalHeight);
        jackPanel.setMinimumSize(new Dimension(200, 40 * jackPanel.getComponentCount()));
        jackPanel.setMinimumSize(new Dimension(200, totalHeight));
        jackPanel.setSize(new Dimension(200, totalHeight));
        return jackPanel;
    }

    public Component createNameEditor() {
        SyntonaModule module = this.moduleView.getModule();
        final JTextFieldDirty textField = new JTextFieldDirty(module.getName(), 12);
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SyntonaModule module = ModuleEditor.this.moduleView.getModule();
                String oldName = module.getName();
                module.setName(textField.getText());
                ModuleEditor.this.moduleView.updateName();
                ModuleEditor.this.moduleView.getPresenter().markDirty();
            }
        });
        textField.addFocusListener(new PlayOverrideFocusListener());
        return textField;
    }

    public void show() {
        JFrame frame = this.moduleView.getFrame();
        this.dialog = new JDialog((Frame)frame, false);
        this.dialog.add(this.fullPanel);
        ComponentAdapter ca = new ComponentAdapter(){
            int counter;

            @Override
            public void componentResized(ComponentEvent e) {
                if (this.counter++ < 4) {
                    Dimension d = ModuleEditor.this.dialog.getSize();
                    Dimension minD = ModuleEditor.this.dialog.getMinimumSize();
                    if (d.width < minD.width) {
                        d.width = minD.width;
                    }
                    if (d.height < minD.height) {
                        d.height = minD.height;
                    }
                    ModuleEditor.this.dialog.setSize(d);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ModuleEditor.this.mComponentX = e.getComponent().getLocation().x;
                ModuleEditor.this.mComponentY = e.getComponent().getLocation().y;
            }
        };
        this.dialog.addComponentListener(ca);
        this.dialog.pack();
        if (this.mBounds != null) {
            this.setDialogLocationByBounds(this.mBounds);
        } else {
            Point loc = this.moduleView.getLocationOnScreen();
            this.dialog.setLocation(loc.x + 20, loc.y + 20);
        }
        this.dialog.setVisible(true);
    }

    public Component getComponent() {
        return this.fullPanel;
    }

    public boolean isVisible() {
        if (this.dialog == null) {
            return false;
        }
        return this.dialog.isVisible();
    }

    public void setVisible(boolean flag) {
        if (this.dialog != null) {
            this.dialog.setVisible(flag);
        }
    }

    public Rectangle getBounds() {
        if (this.fullPanel == null) {
            return this.mBounds;
        }
        Rectangle bounds = new Rectangle();
        bounds.x = this.mComponentX - this.moduleView.getFrame().getLocationOnScreen().x;
        bounds.y = this.mComponentY - this.moduleView.getFrame().getLocationOnScreen().y;
        bounds.width = this.fullPanel.getWidth();
        bounds.height = this.fullPanel.getHeight();
        return bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.mBounds = bounds;
        this.fullPanel.setSize(bounds.width, bounds.height);
        if (this.dialog != null) {
            this.setDialogLocationByBounds(bounds);
        }
    }

    private void setDialogLocationByBounds(Rectangle bounds) {
        int x = bounds.x + this.moduleView.getFrame().getLocationOnScreen().x;
        int y = bounds.y + this.moduleView.getFrame().getLocationOnScreen().y;
        this.dialog.setLocation(x, y);
    }
}

