/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.data.FloatSample;
import com.jsyn.util.SampleLoader;
import com.jsyn.util.WaveFileWriter;
import com.syntona.model.SyntonaSaver;
import com.syntona.model.jsyn.DataQueueOutputJack;
import com.syntona.model.jsyn.SequentialDataModuleBase;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.tools.FileTools;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;

public class FloatSampleModule
extends SequentialDataModuleBase {
    FloatSample mSample = (FloatSample)this.getSequentialData();
    File mSampleFile;
    String mHelpPrefix;
    private OutputDoubleJack mRatePort;
    private static final int MAX_FRAMES = 441000;

    public FloatSampleModule() {
        super(new FloatSample(441000));
        this.mSample.setNumFrames(441000);
        this.mHelpPrefix = this.getHelp();
    }

    @Override
    protected DataQueueOutputJack initJacks() {
        DataQueueOutputJack output = super.initJacks();
        this.mRatePort = new OutputDoubleJack(this, "rate");
        return output;
    }

    @Override
    protected void sendQueueCommand(int opcode) {
        this.passDoubleMessage(this.mSample.getFrameRate(), this.mRatePort);
        super.sendQueueCommand(opcode);
    }

    void setSampleFile(File file) {
        this.mSampleFile = file;
        if (file == null) {
            this.setHelp(this.mHelpPrefix);
        } else {
            this.setHelp(String.valueOf(this.mHelpPrefix) + file.getName());
        }
    }

    File getSampleFile() {
        return this.mSampleFile;
    }

    public void loadFromSampleFile(File file) throws IOException {
        FloatSample sample = SampleLoader.loadFloatSample(file);
        if (sample != null) {
            this.mSample = sample;
            this.mRatePort.setValue(sample.getFrameRate());
            this.setSampleFile(file);
            this.setSequentialData(sample);
        }
    }

    public void saveToSampleFile() throws IOException {
        this.saveToSampleFile(this.mSampleFile);
    }

    public void saveToSampleFile(File file) throws IOException {
        WaveFileWriter writer = new WaveFileWriter(file);
        writer.setFrameRate(44100);
        writer.setSamplesPerFrame(1);
        writer.setBitsPerSample(16);
        float[] buffer = new float[this.mSample.getNumFrames()];
        this.mSample.read(buffer);
        float[] fArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            writer.write(v);
            ++n2;
        }
        writer.close();
        this.setSampleFile(file);
    }

    @Override
    public void saveContents(SyntonaSaver saver, boolean topLevel) throws ParserConfigurationException {
        if (this.getSampleFile() != null) {
            saver.beginElement("sample");
            String path = FileTools.makePathRelative(this.getSampleFile().getAbsolutePath(), saver.getTargetFile());
            saver.addAttribute("file", path);
            saver.endElement();
        }
        super.saveContents(saver, topLevel);
    }

    @Override
    public Class getExportedClass() {
        return FloatSample.class;
    }
}

