/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.jsyn;

import com.jsyn.unitgen.UnitGenerator;
import com.syntona.model.jsyn.GenericUnitModule;
import com.syntona.model.jsyn.JSynBundle;
import com.syntona.plugin.GenericModulePresenter;
import com.syntona.plugin.ModuleInfo;
import com.syntona.plugin.ModulePresenter;
import java.util.logging.Logger;

public class JSynModuleInfo
extends ModuleInfo {
    private static Logger logger = Logger.getLogger(JSynModuleInfo.class.getName());
    Class<?> synthClass;

    public JSynModuleInfo(String group, String type, Class<?> synthClass, String legalString) {
        super(group, type, GenericUnitModule.class, null, legalString);
        this.synthClass = synthClass;
        String webpageName = JSynBundle.createJSynHelp(synthClass);
        this.setupJavaDocHelp(webpageName);
    }

    @Override
    public ModulePresenter makeModulePresenter() throws InstantiationException, IllegalAccessException {
        GenericModulePresenter presenter = (GenericModulePresenter)super.makeModulePresenter();
        UnitGenerator unitGen = (UnitGenerator)this.synthClass.newInstance();
        logger.fine("Creating " + unitGen);
        ((GenericUnitModule)presenter.getModule()).setup(unitGen);
        if (unitGen.isStartRequired()) {
            logger.info("Starting " + unitGen);
            unitGen.start();
        }
        return presenter;
    }
}

