/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.softsynth.math.JustRatio;
import java.util.ArrayList;

public class Intonation {
    private static Intonation instance = new Intonation();
    ArrayList<JustRatio> ratios = new ArrayList();

    public Intonation() {
        this.addInterval(1, 1);
        this.addInterval(16, 15);
        this.addInterval(10, 9);
        this.addInterval(9, 8);
        this.addInterval(8, 7);
        this.addInterval(7, 6);
        this.addInterval(6, 5);
        this.addInterval(5, 4);
        this.addInterval(4, 3);
        this.addInterval(45, 32);
        this.addInterval(3, 2);
        this.addInterval(8, 5);
        this.addInterval(5, 3);
        this.addInterval(7, 4);
        this.addInterval(16, 9);
        this.addInterval(15, 8);
        this.addInterval(2, 1);
    }

    public void addInterval(int numerator, int denominator) {
        JustRatio justRatio = new JustRatio(numerator, denominator);
        double ratio = justRatio.getValue();
        if (this.ratios.size() == 0) {
            this.ratios.add(justRatio);
        } else {
            int i = 0;
            while (i < this.ratios.size()) {
                JustRatio candidate = this.ratios.get(i);
                if (ratio < candidate.getValue()) {
                    this.ratios.add(i, justRatio);
                    return;
                }
                ++i;
            }
            this.ratios.add(justRatio);
        }
    }

    public JustRatio createJustRatio(double ratio) {
        int octave = 0;
        boolean inverted = false;
        if (ratio < 1.0) {
            inverted = true;
            ratio = 1.0 / ratio;
        }
        while (ratio >= 2.0) {
            ++octave;
            ratio *= 0.5;
        }
        double minDeltaSquared = Double.MAX_VALUE;
        JustRatio bestRatio = null;
        int i = 0;
        while (i < this.ratios.size()) {
            JustRatio candidate = this.ratios.get(i);
            double delta = candidate.getValue() - ratio;
            double deltaSquared = delta * delta;
            if (deltaSquared < minDeltaSquared) {
                bestRatio = candidate;
                minDeltaSquared = deltaSquared;
            }
            ++i;
        }
        JustRatio justRatio = new JustRatio(bestRatio.numerator, bestRatio.denominator);
        while (octave > 0) {
            --octave;
            justRatio.numerator *= 2L;
        }
        if (inverted) {
            justRatio.invert();
        }
        return justRatio;
    }

    public void print() {
        for (JustRatio ratio : this.ratios) {
            System.out.println(String.valueOf(ratio.numerator) + "/" + ratio.denominator);
        }
    }

    public static Intonation getInstance() {
        return instance;
    }
}

