/*
 * Decompiled with CFR 0.152.
 */
package com.syntona.model.music;

import com.syntona.gui.keyboard.MusicKeyboardEvent;
import com.syntona.gui.keyboard.MusicKeyboardListener;
import com.syntona.gui.keyboard.ScrollingMusicKeyboardPanel;
import com.syntona.gui.patch.HeaderBox;
import com.syntona.gui.patch.ModuleView;
import com.syntona.plugin.ModulePresenter;
import com.syntona.plugin.OutputDoubleJack;
import com.syntona.plugin.PatchMessageDouble;
import java.awt.Insets;
import javax.swing.JComponent;

public class KeyboardModuleView
extends ModuleView {
    private static final int HEIGHT = 100;
    private static final int WIDTH = 400;

    public KeyboardModuleView() {
    }

    public KeyboardModuleView(ModulePresenter presenter) {
        super(presenter);
    }

    @Override
    public void makeJacks() {
        this.setSize(400, 100);
        Insets insets = this.getInsets();
        this.makeVerticalJackBoxes(insets.left, insets.top + 10, 400 - insets.left - insets.right, 100 - insets.top - insets.bottom - 10);
        ScrollingMusicKeyboardPanel musicKeyboard = new ScrollingMusicKeyboardPanel();
        int y = 90 - insets.top - insets.bottom;
        musicKeyboard.setSize(384, y);
        musicKeyboard.setLocation(insets.left + 8, insets.top + 10);
        this.addComponent(musicKeyboard);
        final OutputDoubleJack onJack = (OutputDoubleJack)this.getModule().getJackByName("on");
        final OutputDoubleJack offJack = (OutputDoubleJack)this.getModule().getJackByName("off");
        MusicKeyboardListener listener = new MusicKeyboardListener(){

            @Override
            public void musicHappened(MusicKeyboardEvent e) {
                PatchMessageDouble pitchMsg = new PatchMessageDouble(e.getPitch());
                if (e.getActionCommand().equals("on")) {
                    onJack.passMessage(pitchMsg);
                } else {
                    offJack.passMessage(pitchMsg);
                }
            }
        };
        musicKeyboard.addMusicKeyboardListener(listener);
    }

    @Override
    public JComponent makeHeader() {
        HeaderBox header = this.createTopHeaderBox(400);
        this.addComponent(header);
        return header;
    }
}

